<?php defined('SYSPATH') or die('No direct script access.');

class Roles_users extends Migration{

    public $schema = 'public';
    public $table = 'roles_users';

    public function up(){
        $this->run_query(DB::expr("
            CREATE TABLE roles_users(
                  user_id integer REFERENCES users(id) ON DELETE CASCADE,
                  role_id integer REFERENCES roles(id) ON DELETE CASCADE
            );

            CREATE INDEX user_id_idx ON roles_users (user_id);
            CREATE INDEX role_id_idx ON roles_users (role_id);
        "));
    }

    public function down(){
        $this->set_schema($this->schema);
        $this->drop_table($this->table);
    }
}